/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageOpenHistory
implements Message {
    private List<Death> deaths;

    public MessageOpenHistory() {
    }

    public MessageOpenHistory(List<Death> deaths) {
        this.deaths = deaths;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClientSide(NetworkEvent.Context context) {
        if (this.deaths.size() > 0) {
            Minecraft.func_71410_x().func_147108_a((Screen)new DeathHistoryScreen(this.deaths));
        } else {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.corpse.no_death_history"), true);
        }
    }

    public MessageOpenHistory fromBytes(PacketBuffer buf) {
        CompoundNBT compound = buf.func_150793_b();
        ListNBT list = compound.func_150295_c("Deaths", 10);
        this.deaths = new ArrayList<Death>();
        for (int i = 0; i < list.size(); ++i) {
            this.deaths.add(Death.fromNBT(list.func_150305_b(i)));
        }
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Death d : this.deaths) {
            CompoundNBT c = d.toNBT(false);
            list.add((Object)c);
        }
        compound.func_218657_a("Deaths", (INBT)list);
        buf.func_150786_a(compound);
    }
}

